<?php

namespace Modules\Paymethod\Models;

use CodeIgniter\Model;

class PaystackModel extends Model
{
	protected $DBGroup              = 'default';
	protected $table                = 'paystacks';
	protected $primaryKey           = 'id';
	protected $useAutoIncrement     = true;
	protected $insertID             = 0;
	protected $returnType           = 'object';
	protected $useSoftDeletes       = true;
	protected $protectFields        = true;
	protected $allowedFields        = ['id','environment','live_s_kye','live_p_kye','test_s_kye','test_p_kye'];

	// Dates
	protected $useTimestamps        = true;
	protected $dateFormat           = 'datetime';
	protected $createdField         = 'created_at';
	protected $updatedField         = 'updated_at';
	protected $deletedField         = 'deleted_at';

	// Validation
	protected $validationRules      = [];
	protected $validationMessages   = [];
	protected $skipValidation       = false;
	protected $cleanValidationRules = true;

	// Callbacks
	protected $allowCallbacks       = true;
	protected $beforeInsert         = [];
	protected $afterInsert          = [];
	protected $beforeUpdate         = [];
	protected $afterUpdate          = [];
	protected $beforeFind           = [];
	protected $afterFind            = [];
	protected $beforeDelete         = [];
	protected $afterDelete          = [];
	
	

    public function getKeys($environment = '0')
    {
        $paystack = $this->where('environment', $environment)->first();
        if (!$paystack) {
            return null;
        }
        return [
            'secret_key' => $environment === '1' ? $paystack->live_s_kye : $paystack->test_s_kye,
            'public_key' => $environment === '1' ? $paystack->live_p_kye : $paystack->test_p_kye,
        ];
    }
}
